/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperExec;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class ASMDiskGroupsUtil
implements CVUHelperConstants {
    private String m_kfodLocation = null;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private String CHECK_RUNNING_HELPER_ARG = "-checkASMRunning";
    private String GET_DISKCOUNT_HELPER_ARG = "-getDiskGroupCount";
    private final String KFOD_ERR_TXT = "KFOD-";

    public void setKfodLocation(String location) {
        this.m_kfodLocation = location;
    }

    public String getKfodLocation() {
        return this.m_kfodLocation;
    }

    public void checkASMRunning(String[] nodeNameArr, List<String> runningNodeList, List<String> failedNodeList) throws ASMDiskGroupsUtilException {
        Trace.out((int)2, (String)"Entry");
        String[] args = new String[]{this.CHECK_RUNNING_HELPER_ARG, VerificationUtil.strArr2String(nodeNameArr, ",")};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            String errMsg = s_gMsgBundle.getMessage("1006", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            throw new ASMDiskGroupsUtilException(errMsg);
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String errMsg = s_gMsgBundle.getMessage("1006", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
            throw new ASMDiskGroupsUtilException(errMsg);
        }
        String[] output = helperExec.getOutput();
        String[] asmRunningArr = null;
        String[] errorArray = null;
        String[] warnArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                warnArray = CVUHelperUtil.fetchWarning(output);
                if (warnArray == null || warnArray.length == 0) {
                    Trace.out((String)"all failed");
                    errorArray = CVUHelperUtil.fetchError(output);
                    String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                    throw new ASMDiskGroupsUtilException(errMsg);
                }
            } else {
                if (status == 1) {
                    Trace.out((String)"some warning nodes");
                    warnArray = CVUHelperUtil.fetchWarning(output);
                }
                Trace.out((String)"fetching successful nodes");
                asmRunningArr = CVUHelperUtil.fetchOutput(output);
            }
        } else {
            Trace.out((String)"cvuhelper failed to produce output");
            String errMsg = s_gMsgBundle.getMessage("1006", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            throw new ASMDiskGroupsUtilException(errMsg);
        }
        if (warnArray != null && warnArray.length > 0) {
            for (String warnStr : warnArray) {
                String warnNode = VerificationUtil.fetchTextByTags(warnStr, "<ASM_FAIL_NODE>", "</ASM_FAIL_NODE>");
                failedNodeList.add(warnNode);
                Trace.out((String)("failed node " + warnNode + " added"));
            }
        }
        if (asmRunningArr != null && asmRunningArr.length > 0) {
            for (String runStr : asmRunningArr) {
                String runNode = VerificationUtil.fetchTextByTags(runStr, "<ASM_SUCC_NODE>", "</ASM_SUCC_NODE>");
                Trace.out((String)("running node is " + runNode));
                runningNodeList.add(runNode);
            }
        }
        Trace.out((int)2, (String)"Exit");
    }

    public int getDiskGroupCount() throws ASMDiskGroupsUtilException {
        Trace.out((int)2, (String)"Entry");
        String[] args = new String[]{this.GET_DISKCOUNT_HELPER_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            String errMsg = s_gMsgBundle.getMessage("1007", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            throw new ASMDiskGroupsUtilException(errMsg);
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String errMsg = s_gMsgBundle.getMessage("1007", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
            throw new ASMDiskGroupsUtilException(errMsg);
        }
        String[] output = helperExec.getOutput();
        String[] errorArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"disk group count couldn't be fetched");
                errorArray = CVUHelperUtil.fetchError(output);
                String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                throw new ASMDiskGroupsUtilException(errMsg);
            }
            Trace.out((String)"disk group count got");
            String dgCountStr = VerificationUtil.fetchTextByTags(outputStr, null, "<ASMDG_COUNT>", "</ASMDG_COUNT>");
            if (dgCountStr != null && dgCountStr.length() > 0) {
                return Integer.parseInt(dgCountStr);
            }
            return 0;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("1007", true, (Object[])new String[]{helperExec.getCommandString()});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        throw new ASMDiskGroupsUtilException(errMsg);
    }

    public boolean getDiskGroups(String[] nodeList, ResultSet dgResultSet, Hashtable<String, List<ASMDiskGroup>> htdg) throws ASMDiskGroupsUtilException {
        Trace.out((int)2, (String)"Entry");
        int nodeCount = nodeList.length;
        VerificationCommand[] getDGListCmdArray = new VerificationCommand[nodeCount];
        String clusterwareHome = null;
        dgResultSet = new ResultSet();
        Trace.out((String)"DiskGroup query using kfod...");
        if (this.m_kfodLocation == null) {
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            try {
                clusterwareHome = clusterwareInfo.isCRSConfigured() ? VerificationUtil.getCRSHome() : VerificationUtil.getHAHome();
            }
            catch (InstallException e) {
                Trace.out((String)("INSTALLEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e)));
                VerificationLogData.logError("INSTALLEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                dgResultSet.addResult(nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                dgResultSet.addErrorDescription(errDesc);
                VerificationLogData.logError(e.getMessage());
                throw new ASMDiskGroupsUtilException(e.getMessage());
            }
            this.m_kfodLocation = clusterwareHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "kfod";
        }
        String[] env = null;
        for (int j = 0; j < nodeCount; ++j) {
            String[] arg = null;
            arg = new SystemFactory().CreateSystem().isUnixSystem() ? new String[]{"-runexe", this.m_kfodLocation, "op=GROUPS", "nohdr=true", "-cv_oh", clusterwareHome} : new String[]{"-runexe", this.m_kfodLocation, "op=GROUPS", "nohdr=true"};
            getDGListCmdArray[j] = new VerificationCommand(nodeList[j], arg, env);
            Trace.out((String)("Building command array entry for: " + nodeList[j] + "|" + VerificationUtil.strArr2String(arg, LSEP) + "|" + VerificationUtil.strArr2String(env, LSEP)));
        }
        Trace.out((String)"Submitting commands...");
        new GlobalHandler().submit((Command[])getDGListCmdArray, 0, dgResultSet);
        if (!dgResultSet.anySuccess()) {
            String message = s_msgBundle.getMessage("5131", true);
            ErrorDescription errorDesc = new ErrorDescription(message);
            dgResultSet.addErrorDescription(nodeList, errorDesc);
            VerificationLogData.logError("disk group retrieval failed on all nodes");
            return false;
        }
        Trace.out((String)"Checking command results...");
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand getDGListCmd = getDGListCmdArray[nodeIndex];
            Result result = getDGListCmd.getResult();
            if (result.getStatus() != 1) continue;
            String node = getDGListCmd.getNode();
            String output = getDGListCmd.getOutput();
            Trace.out((String)("kfod output on node " + node + "= >" + output + "<"));
            ArrayList<ASMDiskGroup> dgl = new ArrayList<ASMDiskGroup>();
            if (output.startsWith("KFOD-")) {
                dgResultSet.addResult(node, 3);
                ErrorDescription error = new ErrorDescription(s_msgBundle.getMessage("5155", true, (Object[])new String[]{node}) + LSEP + output);
                dgResultSet.addErrorDescription(node, error);
                VerificationLogData.logError(output);
                continue;
            }
            boolean isOK = this.parseDGListOutput(node, output, dgl);
            Trace.out((String)("Result of parseDGListOutput(): " + isOK));
            if (isOK) {
                htdg.put(node, dgl);
                continue;
            }
            dgResultSet.addResult(node, 3);
            ErrorDescription error = new ErrorDescription(s_msgBundle.getMessage("5155", true, (Object[])new String[]{node}));
            dgResultSet.addErrorDescription(node, error);
            VerificationLogData.logError(output);
        }
        Trace.out((int)2, (String)"Exit");
        return true;
    }

    public boolean getDiskGroupsDiskMap(String[] nodeList, ResultSet dgResultSet, Hashtable<String, Hashtable<String, List<String>>> htdg) throws ASMDiskGroupsUtilException {
        Trace.out((int)2, (String)"Entry");
        int nodeCount = nodeList.length;
        VerificationCommand[] getDGListCmdArray = new VerificationCommand[nodeCount];
        String clusterwareHome = null;
        String[] env = null;
        dgResultSet = new ResultSet();
        Trace.out((String)"DiskGroup query using kfod...");
        if (this.m_kfodLocation == null) {
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            try {
                clusterwareHome = clusterwareInfo.isCRSConfigured() ? VerificationUtil.getCRSHome() : VerificationUtil.getHAHome();
            }
            catch (InstallException e) {
                VerificationLogData.logError("INSTALLEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                dgResultSet.addResult(nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                dgResultSet.addErrorDescription(errDesc);
                VerificationLogData.logError(e.getMessage());
                throw new ASMDiskGroupsUtilException(e.getMessage());
            }
            this.m_kfodLocation = clusterwareHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "kfod";
        }
        for (int j = 0; j < nodeCount; ++j) {
            String[] arg = null;
            arg = new SystemFactory().CreateSystem().isUnixSystem() ? new String[]{"-runexe", this.m_kfodLocation, "nohdr=true", "op=DISKS", "disks=all", "dscvgroup=TRUE", "-cv_oh", clusterwareHome} : new String[]{"-runexe", this.m_kfodLocation, "nohdr=true", "op=DISKS", "disks=all", "dscvgroup=TRUE"};
            getDGListCmdArray[j] = new VerificationCommand(nodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])getDGListCmdArray, 0, dgResultSet);
        if (!dgResultSet.anySuccess()) {
            String message = s_msgBundle.getMessage("5131", true);
            ErrorDescription errorDesc = new ErrorDescription(message);
            dgResultSet.addErrorDescription(nodeList, errorDesc);
            VerificationLogData.logError("disk group retrieval failed on all nodes");
            return false;
        }
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand getDGListCmd = getDGListCmdArray[nodeIndex];
            Result result = getDGListCmd.getResult();
            if (result.getStatus() != 1) continue;
            String node = getDGListCmd.getNode();
            String output = getDGListCmd.getOutput();
            Trace.out((String)("kfod output on node " + node + "= >" + output + "<"));
            Hashtable<String, List<String>> dgdmap = new Hashtable<String, List<String>>();
            if (output.startsWith("KFOD-")) {
                dgResultSet.addResult(node, 3);
                ErrorDescription error = new ErrorDescription(s_msgBundle.getMessage("5155", true, (Object[])new String[]{node}) + LSEP + output);
                dgResultSet.addErrorDescription(node, error);
                VerificationLogData.logError(output);
                continue;
            }
            boolean isOK = this.parseDiskGroupDiskMap(node, output, dgdmap);
            Trace.out((String)("Result of parseDGListOutput(): " + isOK));
            if (!isOK) {
                dgResultSet.addResult(node, 3);
                ErrorDescription error = new ErrorDescription(s_msgBundle.getMessage("5155", true, (Object[])new String[]{node}));
                dgResultSet.addErrorDescription(node, error);
                VerificationLogData.logError(output);
                continue;
            }
            htdg.put(node, dgdmap);
        }
        Trace.out((int)2, (String)"Exit");
        return true;
    }

    private boolean parseDGListOutput(String node, String output, List<ASMDiskGroup> dgl) {
        Trace.out((int)2, (String)"Entry");
        String[] dgout = output.split("\\n");
        if (dgout.length < 1) {
            Trace.out((String)"Output DG List is empty");
            return false;
        }
        for (int i = 0; i < dgout.length; ++i) {
            Trace.out((String)("DGList: dg[" + i + "]=" + dgout[i]));
            ASMDiskGroup dg = null;
            dg = ASMDiskGroup.parseInput(node, dgout[i]);
            if (dg == null) continue;
            dgl.add(dg);
        }
        Trace.out((int)2, (String)"Exit");
        return true;
    }

    private boolean parseDiskGroupDiskMap(String node, String output, Hashtable<String, List<String>> dgdMap) {
        Trace.out((int)2, (String)"Entry");
        String[] dgout = output.split("\\n");
        if (dgout.length < 1) {
            Trace.out((String)"Output List is empty");
            return false;
        }
        for (String outputLine : dgout) {
            Trace.out((String)("DiskGroupDiskMap: outputLine=" + outputLine));
            String[] values = outputLine.trim().split("[ ]+");
            if (values.length < 5) continue;
            String dgName = values[2];
            String disk = values[1];
            List<String> diskList = dgdMap.get(dgName);
            if (diskList == null) {
                diskList = new ArrayList<String>();
                dgdMap.put(dgName, diskList);
            }
            diskList.add(disk);
        }
        Trace.out((int)2, (String)"Exit");
        return true;
    }
}

